/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.vues;

import fr.asip.cps3.exemple.controleurs.ApplicationControleur;
import fr.asip.cps3.exemple.controleurs.ApplicationVue;
import fr.asip.cps3.exemple.controleurs.MenuControleur;
import fr.asip.cps3.exemple.modele.Application;
import fr.asip.cps3.exemple.modele.MenuApplication;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionControleur;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionVue;
import fr.asip.cps3.exemple.modele.objets.Algo;
import fr.asip.cps3.exemple.modele.objets.Cle;
import fr.asip.cps3.exemple.modele.objets.Objet;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatDouble;
import fr.asip.cps3.exemple.modele.resultats.ResultatDoubleInfo;
import fr.asip.cps3.exemple.modele.resultats.ResultatEmpreinteFichier;
import fr.asip.cps3.exemple.modele.resultats.ResultatEmpreinteMessage;
import fr.asip.cps3.exemple.modele.resultats.ResultatInfo;
import fr.asip.cps3.exemple.modele.resultats.ResultatSignatureFichier;
import fr.asip.cps3.exemple.modele.resultats.ResultatSignatureMessage;
import fr.asip.cps3.exemple.modele.resultats.ResultatSpecifique;
import fr.asip.cps3.exemple.modele.resultats.ResultatSpecifiqueInfo;
import fr.asip.cps3.exemple.modele.resultats.ResultatTriple;
import fr.asip.cps3.exemple.modele.resultats.ResultatTripleInfo;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import fr.asip.cps3.exemple.vues.composants.BarreStatut;
import fr.asip.cps3.exemple.vues.dialogs.SaisieAttributObjet;
import fr.asip.cps3.exemple.vues.dialogs.SaisieCodeNbEssais;
import fr.asip.cps3.exemple.vues.dialogs.SaisieRecyclage;
import fr.asip.cps3.exemple.vues.ecrans.Ecran;
import fr.asip.cps3.exemple.vues.ecrans.EcranUtil;
import fr.asip.cps3.exemple.vues.ecrans.resultats.Sortie;
import fr.asip.cps3.exemple.vues.ecrans.resultats.SortieResultat;
import fr.asip.cps3.exemple.vues.ecrans.resultats.SortieResultatDouble;
import fr.asip.cps3.exemple.vues.ecrans.resultats.SortieResultatDoubleInfo;
import fr.asip.cps3.exemple.vues.ecrans.resultats.SortieResultatEmpreinteFichier;
import fr.asip.cps3.exemple.vues.ecrans.resultats.SortieResultatEmpreinteMessage;
import fr.asip.cps3.exemple.vues.ecrans.resultats.SortieResultatInfo;
import fr.asip.cps3.exemple.vues.ecrans.resultats.SortieResultatSignatureFichier;
import fr.asip.cps3.exemple.vues.ecrans.resultats.SortieResultatSignatureMessage;
import fr.asip.cps3.exemple.vues.ecrans.resultats.SortieResultatSpecifique;
import fr.asip.cps3.exemple.vues.ecrans.resultats.SortieResultatSpecifiqueInfo;
import fr.asip.cps3.exemple.vues.ecrans.resultats.SortieResultatTriple;
import fr.asip.cps3.exemple.vues.ecrans.resultats.SortieResultatTripleInfo;
import fr.asip.cps3.exemple.vues.ecrans.saisie.Saisie1PIN;
import fr.asip.cps3.exemple.vues.ecrans.saisie.Saisie2PIN;
import fr.asip.cps3.exemple.vues.ecrans.saisie.Saisie3PIN;
import fr.asip.cps3.exemple.vues.ecrans.saisie.SaisieFichier;
import fr.asip.cps3.exemple.vues.ecrans.saisie.SaisieFichierSignature;
import fr.asip.cps3.exemple.vues.ecrans.saisie.SaisieFiltreObjet;
import fr.asip.cps3.exemple.vues.ecrans.saisie.SaisieMessage;
import fr.asip.cps3.exemple.vues.ecrans.saisie.SaisieMessageSignature;
import fr.asip.cps3.exemple.vues.ecrans.saisie.SaisieObjet;
import fr.asip.cps3.exemple.vues.ecrans.saisie.SaisieSeed;
import fr.asip.cps3.exemple.vues.menus.ItemMenu;
import fr.asip.cps3.exemple.vues.menus.ItemMenuCheckbox;
import fr.asip.cps3.exemple.vues.menus.Menu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FenetrePrincipale
extends ApplicationVue
implements ActionListener {
    private static Logger log = Logger.getLogger(FenetrePrincipale.class);
    private JFrame fenetre = null;
    private Ecran ecran = null;
    private BarreStatut barreStatut;
    private JMenuBar barreMenus;

    public FenetrePrincipale(ApplicationControleur applicationControleur, Application application) throws ExceptionProgrammeExemple {
        super(applicationControleur);
        try {
            this.construitFenetre(application);
        }
        catch (ExceptionProgrammeExemple exceptionProgrammeExemple) {
            throw exceptionProgrammeExemple;
        }
        catch (Throwable throwable) {
            log.error((Object)("Une erreur inattendue est survenue lors de la construction de la fenetre : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
            throw new ExceptionVue(401, "Une erreur inattendue est survenue");
        }
    }

    public JFrame getFenetre() {
        return this.fenetre;
    }

    private void construitFenetre(Application application) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException, ExceptionVue {
        this.fenetre = new JFrame("Programme d'exemple " + application.getVersion());
        String string = UIManager.getSystemLookAndFeelClassName();
        UIManager.setLookAndFeel(string);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.fenetre.setBounds(0, 0, dimension.width, dimension.height - 30);
        this.fenetre.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FenetrePrincipale.this.ferme();
            }
        });
        this.barreMenus = new JMenuBar();
        this.barreMenus.setBackground(Color.WHITE);
        this.fenetre.setJMenuBar(this.barreMenus);
        MenuApplication menuApplication = application.getMenu();
        menuApplication.initMenus(application);
        this.construitMenu(menuApplication.getItemsMenus());
        if (application.getInfoLibrairieP11() != null) {
            this.barreStatut = new BarreStatut();
            this.barreStatut.setLibrairie(new String(application.getInfoLibrairieP11().libraryDescription).trim());
            this.fenetre.getContentPane().add((Component)this.barreStatut, "South");
        }
    }

    public void construitMenu(TreeMap<String, JMenuItem> treeMap) throws ExceptionVue {
        try {
            Vector<JMenuItem> vector = new Vector<JMenuItem>();
            Vector<JMenuItem> vector2 = new Vector<JMenuItem>();
            if (treeMap != null && treeMap.values() != null) {
                for (JMenuItem jMenuItem : treeMap.values()) {
                    boolean bl = false;
                    while (!bl && !vector.contains(jMenuItem)) {
                        JMenuItem jMenuItem2;
                        String string;
                        if (jMenuItem instanceof ItemMenu || jMenuItem instanceof ItemMenuCheckbox) {
                            string = jMenuItem instanceof ItemMenu ? ((ItemMenu)jMenuItem).getIdParent() : ((ItemMenuCheckbox)jMenuItem).getIdParent();
                            if (string != null) {
                                jMenuItem2 = treeMap.get(string);
                                if (jMenuItem2 == null) continue;
                                vector.add(jMenuItem);
                                if (jMenuItem instanceof ItemMenu) {
                                    ((ItemMenu)jMenuItem).setEcouteur(this);
                                } else {
                                    ((ItemMenuCheckbox)jMenuItem).setEcouteur(this);
                                }
                                jMenuItem2.add(jMenuItem);
                                jMenuItem2.revalidate();
                                continue;
                            }
                            bl = true;
                            vector2.add(jMenuItem);
                            continue;
                        }
                        if (!(jMenuItem instanceof Menu)) continue;
                        string = ((Menu)jMenuItem).getIdParent();
                        if (string != null) {
                            jMenuItem2 = treeMap.get(string);
                            if (jMenuItem2 == null) continue;
                            vector.add(jMenuItem);
                            jMenuItem2.add(jMenuItem);
                            jMenuItem2.revalidate();
                            continue;
                        }
                        bl = true;
                        vector2.add(jMenuItem);
                    }
                }
            }
            if (this.barreMenus != null) {
                Iterator<Object> iterator = vector2.iterator();
                while (iterator.hasNext()) {
                    this.barreMenus.add((JMenuItem)iterator.next());
                }
            }
        }
        catch (Throwable throwable) {
            log.error((Object)("Une erreur inattendue est survenue lors de la construction du menu : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
            throw new ExceptionVue(402, "Une erreur inattendue est survenue");
        }
    }

    @Override
    public void ferme() {
        if (this.fenetre != null) {
            this.fenetre.setVisible(false);
            this.fenetre.dispose();
        }
        log.debug((Object)"Sortie du programme");
    }

    @Override
    public void affiche() {
        if (this.fenetre != null) {
            this.fenetre.setVisible(true);
        }
    }

    public BarreStatut getBarreStatut() {
        return this.barreStatut;
    }

    private void masqueElementsEcran() {
        EcranUtil.supprimeTousLesComposants((JPanel)this.fenetre.getContentPane());
        this.fenetre.setLayout(null);
        this.fenetre.getContentPane().add((Component)this.barreStatut, "South");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof ItemMenu || actionEvent.getSource() instanceof ItemMenuCheckbox) {
            this.masqueElementsEcran();
            if (actionEvent.getSource() != null && actionEvent.getSource() instanceof ItemMenu && "3,0".equalsIgnoreCase(((ItemMenu)actionEvent.getSource()).getId())) {
                File file;
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setAcceptAllFileFilterUsed(false);
                jFileChooser.setFileFilter(Application.getFiltreLibrairie());
                jFileChooser.setDialogTitle("S\u00e9lectionnez une librairie");
                int n = jFileChooser.showOpenDialog(this.fenetre);
                if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                    try {
                        if (this.getControlleur() != null && file != null) {
                            this.getControlleur().declencheChargementLibrairie(file.getAbsolutePath());
                        }
                    }
                    catch (ExceptionControleur exceptionControleur) {
                        JOptionPane.showMessageDialog(this.fenetre, "Une erreur est survenue lors du chargement de la nouvelle librairie", exceptionControleur.getTypeException(), 0);
                    }
                }
            } else if (actionEvent.getSource() != null && actionEvent.getSource() instanceof ItemMenuCheckbox && "3,1".equalsIgnoreCase(((ItemMenuCheckbox)actionEvent.getSource()).getId())) {
                if (MenuApplication.isMenuVerrouille()) {
                    MenuApplication.setMenuVerrouille(false);
                    ((ItemMenuCheckbox)actionEvent.getSource()).setMnemonic('c');
                    this.getControlleur().deverrouilleMenu();
                } else {
                    MenuApplication.setMenuVerrouille(true);
                    ((ItemMenuCheckbox)actionEvent.getSource()).setMnemonic('h');
                    this.getControlleur().verrouilleMenu();
                }
            } else {
                if (this.barreMenus != null) {
                    this.barreMenus.setEnabled(false);
                }
                if (this.getControlleur() != null) {
                    this.getControlleur().declencheOperationMenu(actionEvent.getSource());
                }
                if (this.barreMenus != null) {
                    this.barreMenus.setEnabled(true);
                }
            }
        } else if (actionEvent.getSource() instanceof JButton && this.ecran != null && this.getControlleur() != null) {
            Vector<Object> vector = new Vector();
            switch (this.ecran.getType()) {
                case 1: 
                case 2: {
                    vector = this.getControlleur().declencheValidationSaisie((Saisie1PIN)this.ecran);
                    if (vector != null && vector.size() != 0) break;
                    this.masqueElementsEcran();
                    this.getControlleur().declencheOperationSaisie((Saisie1PIN)this.ecran);
                    break;
                }
                case 3: {
                    vector = this.getControlleur().declencheValidationSaisie((Saisie2PIN)this.ecran);
                    if (vector != null && vector.size() != 0) break;
                    this.masqueElementsEcran();
                    this.getControlleur().declencheOperationSaisie((Saisie2PIN)this.ecran);
                    break;
                }
                case 4: {
                    vector = this.getControlleur().declencheValidationSaisie((Saisie3PIN)this.ecran);
                    if (vector != null && vector.size() != 0) break;
                    this.masqueElementsEcran();
                    this.getControlleur().declencheOperationSaisie((Saisie3PIN)this.ecran);
                    break;
                }
                case 12: {
                    vector = this.getControlleur().declencheValidationSaisie((SaisieObjet)this.ecran);
                    if (vector != null && vector.size() != 0) break;
                    this.masqueElementsEcran();
                    this.getControlleur().declencheOperationSaisie((SaisieObjet)this.ecran);
                    break;
                }
                case 13: {
                    vector = this.getControlleur().declencheValidationSaisie((SaisieObjet)this.ecran);
                    if (vector != null && vector.size() != 0) break;
                    this.masqueElementsEcran();
                    this.getControlleur().declencheOperationSaisie((SaisieObjet)this.ecran);
                    break;
                }
                case 14: {
                    this.masqueElementsEcran();
                    this.getControlleur().declencheOperationSaisie((SaisieFiltreObjet)this.ecran);
                    break;
                }
                case 5: {
                    vector = this.getControlleur().declencheValidationSaisie((SaisieSeed)this.ecran);
                    if (vector != null && vector.size() != 0) break;
                    this.masqueElementsEcran();
                    this.getControlleur().declencheOperationSaisie((SaisieSeed)this.ecran);
                    break;
                }
                case 6: {
                    vector = this.getControlleur().declencheValidationSaisie((SaisieMessage)this.ecran);
                    if (vector != null && vector.size() != 0) break;
                    this.masqueElementsEcran();
                    this.getControlleur().declencheOperationSaisie((SaisieMessage)this.ecran);
                    break;
                }
                case 7: {
                    vector = this.getControlleur().declencheValidationSaisie((SaisieFichier)this.ecran);
                    if (vector != null && vector.size() != 0) break;
                    this.masqueElementsEcran();
                    this.getControlleur().declencheOperationSaisie((SaisieFichier)this.ecran);
                    break;
                }
                case 8: 
                case 10: {
                    vector = this.getControlleur().declencheValidationSaisie((SaisieMessageSignature)this.ecran);
                    if (vector != null && vector.size() != 0) break;
                    this.masqueElementsEcran();
                    this.getControlleur().declencheOperationSaisie((SaisieMessageSignature)this.ecran);
                    break;
                }
                case 9: 
                case 11: {
                    vector = this.getControlleur().declencheValidationSaisie((SaisieFichierSignature)this.ecran);
                    if (vector != null && vector.size() != 0) break;
                    this.masqueElementsEcran();
                    this.getControlleur().declencheOperationSaisie((SaisieFichierSignature)this.ecran);
                }
            }
            if (vector != null && vector.size() > 0) {
                String string = new String();
                Iterator<Object> iterator = vector.iterator();
                while (iterator.hasNext()) {
                    string = string + (String)iterator.next() + "\n";
                }
                JOptionPane.showMessageDialog(this.fenetre, string, "Saisie incorrecte", 2);
            }
        }
    }

    @Override
    public void afficheResultat(Resultat resultat) throws ExceptionVue {
        try {
            if (resultat instanceof ResultatTripleInfo) {
                this.ecran = new SortieResultatTripleInfo(this);
            } else if (resultat instanceof ResultatSignatureMessage) {
                this.ecran = new SortieResultatSignatureMessage(this);
            } else if (resultat instanceof ResultatSignatureFichier) {
                this.ecran = new SortieResultatSignatureFichier(this);
            } else if (resultat instanceof ResultatEmpreinteMessage) {
                this.ecran = new SortieResultatEmpreinteMessage(this);
            } else if (resultat instanceof ResultatEmpreinteFichier) {
                this.ecran = new SortieResultatEmpreinteFichier(this);
            } else if (resultat instanceof ResultatDoubleInfo) {
                this.ecran = new SortieResultatDoubleInfo(this);
            } else if (resultat instanceof ResultatInfo) {
                this.ecran = new SortieResultatInfo(this);
            } else if (resultat instanceof ResultatTriple) {
                this.ecran = new SortieResultatTriple(this);
            } else if (resultat instanceof ResultatDouble) {
                this.ecran = new SortieResultatDouble(this);
            } else if (resultat instanceof ResultatSpecifiqueInfo) {
                this.ecran = new SortieResultatSpecifiqueInfo(this);
            } else if (resultat instanceof ResultatSpecifique) {
                this.ecran = new SortieResultatSpecifique(this);
            } else if (resultat instanceof Resultat) {
                this.ecran = new SortieResultat(this);
            }
            if (this.ecran != null) {
                this.ecran.affiche();
                ((Sortie)this.ecran).setOperation(resultat.getTraitement());
                if (resultat.getCodeRetour() == 0L && resultat.getRetour() != null && resultat.getRetour().length() != 0) {
                    ((Sortie)this.ecran).setRetour(resultat.getRetour());
                } else {
                    ((Sortie)this.ecran).setRetour(resultat.getCodeRetourStr());
                }
                if (resultat instanceof ResultatDouble || resultat instanceof ResultatDoubleInfo || resultat instanceof ResultatTriple || resultat instanceof ResultatTripleInfo) {
                    if (resultat instanceof ResultatDouble || resultat instanceof ResultatTriple) {
                        ((SortieResultatDouble)this.ecran).setOperation2(((ResultatDouble)resultat).getOperation2());
                        ((SortieResultatDouble)this.ecran).setCodeRetour2(((ResultatDouble)resultat).getCodeRetour2());
                    } else {
                        ((SortieResultatDoubleInfo)this.ecran).setOperation2(((ResultatDoubleInfo)resultat).getOperation2());
                        ((SortieResultatDoubleInfo)this.ecran).setCodeRetour2(((ResultatDoubleInfo)resultat).getCodeRetour2());
                    }
                }
                if (resultat instanceof ResultatTriple || resultat instanceof ResultatTripleInfo) {
                    if (resultat instanceof ResultatTriple) {
                        ((SortieResultatTriple)this.ecran).setOperation3(((ResultatTriple)resultat).getOperation3());
                        ((SortieResultatTriple)this.ecran).setCodeRetour3(((ResultatTriple)resultat).getCodeRetour3());
                    } else {
                        ((SortieResultatTripleInfo)this.ecran).setOperation3(((ResultatTripleInfo)resultat).getOperation3());
                        ((SortieResultatTripleInfo)this.ecran).setCodeRetour3(((ResultatTripleInfo)resultat).getCodeRetour3());
                    }
                }
                if (resultat instanceof ResultatEmpreinteMessage || resultat instanceof ResultatEmpreinteFichier) {
                    if (resultat instanceof ResultatEmpreinteMessage) {
                        ((SortieResultatEmpreinteMessage)this.ecran).setEmpreinte(((ResultatEmpreinteMessage)resultat).getEmpreinte());
                    } else {
                        ((SortieResultatEmpreinteFichier)this.ecran).setEmpreinte(((ResultatEmpreinteFichier)resultat).getEmpreinte());
                    }
                } else if (resultat instanceof ResultatSignatureMessage || resultat instanceof ResultatSignatureFichier) {
                    if (resultat instanceof ResultatSignatureMessage) {
                        ((SortieResultatSignatureMessage)this.ecran).setSignature(((ResultatSignatureMessage)resultat).getSignature());
                    } else {
                        ((SortieResultatSignatureFichier)this.ecran).setSignature(((ResultatSignatureFichier)resultat).getSignature());
                    }
                }
                if (this.barreStatut != null) {
                    this.barreStatut.setVisible(false);
                }
                if (this.ecran instanceof SortieResultatInfo) {
                    ((SortieResultatInfo)this.ecran).setInfos((ResultatInfo)resultat);
                }
                if (this.ecran instanceof SortieResultatSpecifiqueInfo) {
                    ((SortieResultatSpecifiqueInfo)this.ecran).setInfos((ResultatSpecifiqueInfo)resultat);
                }
                if (this.fenetre != null) {
                    this.fenetre.getContentPane().validate();
                    this.fenetre.getContentPane().repaint();
                }
            }
        }
        catch (Throwable throwable) {
            log.error((Object)("Une erreur inattendue est survenue lors de l'affichage du resultat : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
            throw new ExceptionVue(403, "Une erreur inattendue est survenue");
        }
    }

    @Override
    public void afficheEcran(int n, Object object) throws ExceptionVue {
        try {
            switch (n) {
                case 3: {
                    this.ecran = new Saisie2PIN(this, n);
                    break;
                }
                case 4: {
                    this.ecran = new Saisie3PIN(this, n, "Entrez le code PIN actuel :", "Entrez le nouveau code PIN", "Entrez le nouveau code PIN \u00e0 nouveau");
                    break;
                }
                case 2: {
                    this.ecran = new Saisie1PIN(this, n, "Entrez le code PIN :");
                    break;
                }
                case 1: {
                    this.ecran = new Saisie1PIN(this, n, "Entrez le code PUK :");
                    break;
                }
                case 12: {
                    this.ecran = new SaisieObjet(this, n);
                    break;
                }
                case 13: {
                    this.ecran = new SaisieObjet(this, n, (Objet)object);
                    break;
                }
                case 14: {
                    this.ecran = new SaisieFiltreObjet(this, n);
                    break;
                }
                case 6: {
                    if (!(object instanceof Algo)) break;
                    this.ecran = new SaisieMessage(this, n, (Algo)object);
                    break;
                }
                case 7: {
                    if (!(object instanceof Algo)) break;
                    this.ecran = new SaisieFichier(this, n, (Algo)object);
                    break;
                }
                case 8: {
                    Vector vector;
                    if (!(object instanceof Vector) || (vector = (Vector)object) == null || vector.size() != 2 || !(vector.get(0) instanceof Algo) || !(vector.get(1) instanceof Cle)) break;
                    this.ecran = new SaisieMessageSignature(this, n, (Algo)vector.get(0), (Cle)vector.get(1));
                    break;
                }
                case 9: {
                    Vector vector;
                    if (!(object instanceof Vector) || (vector = (Vector)object) == null || vector.size() != 2 || !(vector.get(0) instanceof Algo) || !(vector.get(1) instanceof Cle)) break;
                    this.ecran = new SaisieFichierSignature(this, n, (Algo)vector.get(0), (Cle)vector.get(1));
                    break;
                }
                case 10: {
                    Vector vector;
                    if (!(object instanceof Vector) || (vector = (Vector)object) == null || vector.size() != 4 || !(vector.get(0) instanceof Algo) || !(vector.get(1) instanceof Cle) || !(vector.get(2) instanceof char[]) || !(vector.get(3) instanceof String)) break;
                    this.ecran = new SaisieMessageSignature(this, n, (Algo)vector.get(0), (Cle)vector.get(1), (char[])vector.get(2), (String)vector.get(3));
                    break;
                }
                case 11: {
                    Vector vector;
                    if (!(object instanceof Vector) || (vector = (Vector)object) == null || vector.size() != 4 || !(vector.get(0) instanceof Algo) || !(vector.get(1) instanceof Cle) || !(vector.get(2) instanceof String) || !(vector.get(3) instanceof String)) break;
                    this.ecran = new SaisieFichierSignature(this, n, (Algo)vector.get(0), (Cle)vector.get(1), (String)vector.get(2), (String)vector.get(3));
                    break;
                }
                case 5: {
                    this.ecran = new SaisieSeed(this, n);
                }
            }
            if (this.ecran != null) {
                this.ecran.affiche();
            }
        }
        catch (Throwable throwable) {
            log.error((Object)("Une erreur inattendue est survenue lors de l'affichage de l'ecran : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
            throw new ExceptionVue(404, "Une erreur inattendue est survenue");
        }
    }

    @Override
    public void afficheEcran(int n) throws ExceptionVue {
        this.afficheEcran(n, null);
    }

    @Override
    public void chargementLibrairie(String string) {
        if (this.barreStatut != null) {
            this.barreStatut.setLibrairie(string);
            JOptionPane.showMessageDialog(this.fenetre, "La librairie " + string + " a \u00e9t\u00e9 charg\u00e9e avec succ\u00e8s");
            this.barreStatut.setVisible(true);
        }
    }

    @Override
    public void problemeChargementLibrairie(int n, Application application) {
        switch (n) {
            case 501: {
                JOptionPane.showMessageDialog(this.fenetre, "La librairie sp\u00e9cifi\u00e9e est inaccessible ou invalide!\nLa librairie pr\u00e9c\u00e8dente va \u00eatre recharg\u00e9e", "Erreur librairie PKCS#11", 0);
                break;
            }
            case 502: {
                JOptionPane.showMessageDialog(this.fenetre, "Une erreur est survenue au chargement de la librairie des traitements sp\u00e9cifiques.\nLe module Traitements sp\u00e9cifiques est inutilisable.", "Erreur librairie native des traitements sp\u00e9cifiques", 0);
                application.getMenu().setItemMenuNonActif("1");
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this.fenetre, "Une erreur inattendue est survenue", "Erreur librairie", 0);
            }
        }
    }

    @Override
    public void majMenus(Application application) {
        MenuControleur.majMenus(application);
    }

    @Override
    public void afficheException(Exception exception) {
        if (exception != null && exception.getMessage() != null && exception instanceof ExceptionProgrammeExemple) {
            JOptionPane.showMessageDialog(this.fenetre, exception.getMessage(), ((ExceptionProgrammeExemple)exception).getTypeException(), 0);
        } else {
            JOptionPane.showMessageDialog(this.fenetre, "Une erreur inconnue est survenue", "Erreur", 0);
        }
    }

    @Override
    public int demandeConnexionLecteur() {
        Object[] objectArray = new Object[]{"Relancer", "Annuler"};
        int n = 0;
        n = JOptionPane.showOptionDialog(this.fenetre, "Veuillez connecter un lecteur avec une carte support\u00e9e et relancer", "Authentification Impossible", 0, 0, null, objectArray, objectArray[0]);
        if (n == 1) {
            n = -1;
        }
        return n;
    }

    @Override
    public int demandeInsertionCarte() {
        Object[] objectArray = new Object[]{"Relancer", "Annuler"};
        int n = 0;
        n = JOptionPane.showOptionDialog(this.fenetre, "Veuillez ins\u00e9rer une carte support\u00e9e et relancer", "Authentification Impossible", 0, 0, null, objectArray, objectArray[0]);
        if (n == 1) {
            n = -1;
        }
        return n;
    }

    @Override
    public Object[] demandeSaisieCodePorteur(long l, long l2, String string) {
        Object[] objectArray = new Object[2];
        SaisieCodeNbEssais saisieCodeNbEssais = new SaisieCodeNbEssais(this.fenetre, "Saisie du code porteur de la carte", TraitementsUtil.retranscritFlag(l2), string, TraitementsUtil.retranscritFlag(l), TraitementsUtil.retranscritCouleurFlag(l));
        saisieCodeNbEssais.affiche();
        objectArray[0] = saisieCodeNbEssais.getChoixUtilisateur();
        objectArray[1] = saisieCodeNbEssais.getCode();
        return objectArray;
    }

    @Override
    public Object[] demandeRecyclageCodePorteur(long l, long l2, long l3, String string) {
        Object[] objectArray = new Object[4];
        SaisieRecyclage saisieRecyclage = new SaisieRecyclage(this.fenetre, "Recyclage de la carte", TraitementsUtil.retranscritFlag(l2), TraitementsUtil.retranscritFlag(l3), string, TraitementsUtil.retranscritFlag(l), TraitementsUtil.retranscritCouleurFlag(l));
        saisieRecyclage.affiche();
        objectArray[0] = saisieRecyclage.getChoixUtilisateur();
        objectArray[1] = saisieRecyclage.getCodeDeblocage();
        objectArray[2] = saisieRecyclage.getCodePorteur1();
        objectArray[3] = saisieRecyclage.getCodePorteur2();
        return objectArray;
    }

    @Override
    public int demandeChoixNbEssaisPossiblesAvantBlocageCodePorteur() {
        Object[] objectArray = new Object[]{"Code \u00e0 3 tentatives", "Code \u00e0 N tentatives", "Annuler"};
        int n = 0;
        n = JOptionPane.showOptionDialog(this.fenetre, "Afin de constater la transposition de l'\u00e9tat de saisie\ndu code porteur, vous \u00eates invit\u00e9 \u00e0 saisir un code porteur erron\u00e9.\nVeuillez choisir une des options suivantes pour ce test :", "Etat de saisie du code porteur", 0, 2, null, objectArray, objectArray[0]);
        if (++n == 3) {
            n = -1;
        }
        return n;
    }

    @Override
    public int demandeActionLecteurCarte(int n, String string) {
        String string2;
        String string3;
        Object[] objectArray = new Object[]{"Valider", "Annuler"};
        int n2 = 0;
        switch (n) {
            case 1: {
                string3 = "Retirez une carte d'un lecteur, puis cliquez sur Valider";
                string2 = "Retrait carte";
                break;
            }
            case 2: {
                if (string == null) {
                    return 0;
                }
                string3 = "Ins\u00e9rez la carte " + string + " dans un des lecteurs, puis Valider";
                string2 = "Retrait carte";
                break;
            }
            case 3: {
                string3 = "Veuillez d\u00e9brancher un lecteur contenant une carte, puis cliquez sur Valider";
                string2 = "Retrait lecteur";
                break;
            }
            case 4: {
                if (string == null) {
                    return 0;
                }
                string3 = "Veuillez rebrancher le lecteur ou r\u00e9introduire la carte " + string + " dans un autre lecteur connect\u00e9, puis cliquez sur Valider";
                string2 = "Retrait lecteur";
                break;
            }
            default: {
                return 0;
            }
        }
        n2 = JOptionPane.showOptionDialog(this.fenetre, string3, string2, 0, 2, null, objectArray, objectArray[0]);
        if (n2 == 1) {
            n2 = -1;
        }
        return n2;
    }

    @Override
    public void declencheAlerteCarteRetrouvee() {
        JOptionPane.showMessageDialog(this.fenetre, "La carte a \u00e9t\u00e9 retrouv\u00e9e", "Information", 1);
    }

    @Override
    public Object[] declencheDemandeModificationObjetDonneesApplicatives(byte[] byArray) {
        Object[] objectArray = new Object[2];
        SaisieAttributObjet saisieAttributObjet = new SaisieAttributObjet(this.fenetre, "Modification d\u2019un jeton d\u2019\u00e9tablissement", "CPS_DATA");
        saisieAttributObjet.setAttribut(TraitementsUtil.getHexadecimal(byArray, 16));
        saisieAttributObjet.affiche();
        objectArray[0] = saisieAttributObjet.getChoixUtilisateur();
        objectArray[1] = saisieAttributObjet.getValeurAttribut();
        return objectArray;
    }
}

